package gov.va.med.mhv.sm.web.smActions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.web.form.RecallMessageVO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RecallMessage extends ReadMessage{
	private static final long serialVersionUID = 6347027642913892225L;
	private static final Log log = LogFactory.getLog(RecallMessage.class);
	private MessageService messageService;
	private UserManagementService userService;
	private Collection recallMessageUsersList;
	private String recallMessageSubmit;
	private String messageRecallStatus;
	private String STRUTS_RESULT_CANCEL = "CANCEL";
	private String STRUTS_RESULT_READMESSAGE = "READMESSAGE";
	

	private static final String VIEW_MESSAGE_STATUS="viewMessageStatus";
	

	public void prepare() throws Exception{
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		
		messageService = (MessageService)ctx.getBean("messageService");
		userService = (UserManagementService)ctx.getBean("userManagementService");
	}
	
	public String viewMessageStatus(){
		
		Message message = (Message)getSession().getAttribute(CURRENT_MESSAGE);
		List usersList = new ArrayList(); 
		if(message.getRecipientType().equals(ParticipantTypeEnum.DISTRIBUTION_GROUP)){
			ServiceResponse<List<Object[]>> serviceResponse = messageService.getDistributionGroupMessagesByIds(message.getSenderId(), message.getRecipientId(), message.getChecksum().trim());	
			List<Object[]> responseObj = serviceResponse.getPayload();
			for(Object[] object : responseObj){
				if(object[7]!=null && object[7].equals("0")){
					RecallMessageVO messageVo = new RecallMessageVO();
					messageVo.setPatientName(object[2]+" ,"+object[3]);
					messageVo.setDob(object[4].toString());
					messageVo.setNssn(object[5].toString());
					messageVo.setReadDate(object[6]!=null?object[6].toString():"");
					messageVo.setReadStatus(object[6]!=null?"Read":"");
					usersList.add(messageVo);		
				}
			}
			setRecallMessageUsersList(usersList);
		}else if(message.getRecipientType().equals(ParticipantTypeEnum.PATIENT)){
			ServiceResponse<List<Object[]>> serviceResponse = userService.getUserDetailsByIds(message.getId(), message.getRecipientId());
			if(serviceResponse.getPayload()!=null){
				RecallMessageVO messageVo = new RecallMessageVO();
				List<Object[]> responseObject = serviceResponse.getPayload();
				Object[] object = responseObject.get(0);
				messageVo.setPatientName(object[0]+" ,"+object[1]);;
				messageVo.setDob(object[2].toString());
				messageVo.setNssn(object[3].toString());
				messageVo.setReadDate(object[4]!=null?object[4].toString():"");
				messageVo.setReadStatus(object[4]!=null?"Read":"");
				usersList.add(messageVo);
			}
			setRecallMessageUsersList(usersList);
		}
		return VIEW_MESSAGE_STATUS;
	}
	
	public String recallMessage() {
		//check params
		if( "yes".equalsIgnoreCase(recallMessageSubmit) ) 
		{
			Message messageToRead = (Message)getSession().getAttribute(CURRENT_MESSAGE);
			if(messageToRead.getRecipientType().equals(ParticipantTypeEnum.DISTRIBUTION_GROUP)){
				return recallDistMessages(messageToRead);
			}else if(messageToRead.getRecipientType().equals(ParticipantTypeEnum.PATIENT)){
				return recallPatientMessage(messageToRead);
			}
			return STRUTS_RESULT_READMESSAGE;
		} else {
			//no
			return STRUTS_RESULT_CANCEL;
		}
		
	}
	
	public String recallDistMessages(Message message){
		Clinician clinician = 	(Clinician)getSession().getAttribute(CURRENT_USER);
		ServiceResponse<Boolean> recallResponse = messageService.recallDistributionGroupMessages(message.getId());
		
		if(isMessageReadByAnyRecipient() && recallResponse.getPayload() ) {
			addActionError("Your message was recalled but may have been read by one or more of the members of the Distribution Group.  Please contact your MHV Coordinator with message ID "+message.getId()+".");
			setMessageRecallStatus("Recalled");
		} 
		else if(recallResponse.getPayload()){
			addActionError("Your message has been successfully recalled.");
			setMessageRecallStatus("Recalled");
		}else if(!recallResponse.getPayload()){
			addActionError("Message recall failed, please try again later.");
			setMessageRecallStatus("Failed");
		}
		messageService.updateDgRecallMessages(message.getId(), clinician.getId(), getMessageRecallStatus());
		return STRUTS_RESULT_READMESSAGE;
	}
	
	public String recallPatientMessage(Message message){
		
		Clinician clinician = 	(Clinician)getSession().getAttribute(CURRENT_USER);
		ServiceResponse result = messageService.recall(message.getId(),clinician);
		if(handleMessages(result))
		{
			if(log.isInfoEnabled()){
				log.info("###9001###Recall Patient Message Failed"+message.getId());
			}
			setMessageRecallStatus("Failed");
			messageService.updateDgRecallMessages(message.getId(), clinician.getId(), getMessageRecallStatus());
			return STRUTS_RESULT_CANCEL;
		}else 
		{
			if(message.getReadReceipt()!=null) {
				//Message was not read so successful
				
				addActionError("Your message was recalled but has already been read by the recipient.<br>" +
					       "Please contact your MHV Coordinator with message ID " + message.getId()+".");
				setMessageRecallStatus("Recalled");
			} else {
				//Message was read so unsuccessful (Could be a breech)
				addActionError("Your message has been successfully recalled.");
				setMessageRecallStatus("Recalled");
			}
			Message msg = (Message)result.getPayload();
			if( msg != null ) {
				getSession().setAttribute(CURRENT_MESSAGE, msg);
			}
		}
		messageService.updateDgRecallMessages(message.getId(), clinician.getId(), getMessageRecallStatus());
		return STRUTS_RESULT_READMESSAGE;
	}
	

	public boolean isMessageReadByAnyRecipient(){
		Message currentMessage = (Message)getSession().getAttribute(CURRENT_MESSAGE);
		boolean messageReadFlag=false;
		ServiceResponse<List<Object[]>> serviceResponse = messageService.getDistributionGroupMessagesByIds(currentMessage.getSenderId(), currentMessage.getRecipientId(), currentMessage.getChecksum().trim());	
		List<Object[]> responseObj = serviceResponse.getPayload();
		for(Object[] object : responseObj){
			Long userId = new Long(object[1].toString());
			if(log.isInfoEnabled()){
				log.info("###9005###Recall Message Read Status->Logged in User"+getCurrentUser().getId());
			}
			if(!userId.equals(getCurrentUser().getId())){
				if(log.isInfoEnabled()){
					log.info("###9006###User from List"+userId);
				}
				if(object[6]!=null && object[6]!=""){
					messageReadFlag=true;
					break;
				}
			}
		}	
		return messageReadFlag;
	}
	
	
	public MessageService getMessageService() {
		return messageService;
	}

	public void setMessageService(MessageService messageService) {
		this.messageService = messageService;
	}
	public Collection getRecallMessageUsersList() {
		return recallMessageUsersList;
	}

	public void setRecallMessageUsersList(Collection recallMessageUsersList) {
		this.recallMessageUsersList = recallMessageUsersList;
	}
	
	public String getRecallMessageSubmit() {
		return recallMessageSubmit;
	}

	public void setRecallMessageSubmit(String recallMessageSubmit) {
		this.recallMessageSubmit = recallMessageSubmit;
	}
	
	public String getMessageRecallStatus() {
		return messageRecallStatus;
	}

	public void setMessageRecallStatus(String messageRecallStatus) {
		this.messageRecallStatus = messageRecallStatus;
	}

}
